// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     content/common/presentation/presentation_service.mojom
//

package org.chromium.mojom.presentation;

class PresentationService_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<PresentationService, PresentationService.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<PresentationService, PresentationService.Proxy>() {
    
        public String getName() {
            return "presentation::PresentationService";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, PresentationService impl) {
            return new Stub(core, impl);
        }
    
        public PresentationService[] buildArray(int size) {
          return new PresentationService[size];
        }
    };

    private static final int SET_DEFAULT_PRESENTATION_URL_ORDINAL = 0;
    private static final int SET_CLIENT_ORDINAL = 1;
    private static final int LISTEN_FOR_SCREEN_AVAILABILITY_ORDINAL = 2;
    private static final int STOP_LISTENING_FOR_SCREEN_AVAILABILITY_ORDINAL = 3;
    private static final int LISTEN_FOR_DEFAULT_SESSION_START_ORDINAL = 4;
    private static final int START_SESSION_ORDINAL = 5;
    private static final int JOIN_SESSION_ORDINAL = 6;
    private static final int SEND_SESSION_MESSAGE_ORDINAL = 7;
    private static final int CLOSE_SESSION_ORDINAL = 8;
    private static final int LISTEN_FOR_SESSION_STATE_CHANGE_ORDINAL = 9;
    private static final int LISTEN_FOR_SESSION_MESSAGES_ORDINAL = 10;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements PresentationService.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void setDefaultPresentationUrl(String url) {
            PresentationServiceSetDefaultPresentationUrlParams _message = new PresentationServiceSetDefaultPresentationUrlParams();
            _message.url = url;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(SET_DEFAULT_PRESENTATION_URL_ORDINAL)));
        }

        @Override
        public void setClient(PresentationServiceClient client) {
            PresentationServiceSetClientParams _message = new PresentationServiceSetClientParams();
            _message.client = client;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(SET_CLIENT_ORDINAL)));
        }

        @Override
        public void listenForScreenAvailability(String url) {
            PresentationServiceListenForScreenAvailabilityParams _message = new PresentationServiceListenForScreenAvailabilityParams();
            _message.url = url;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(LISTEN_FOR_SCREEN_AVAILABILITY_ORDINAL)));
        }

        @Override
        public void stopListeningForScreenAvailability(String url) {
            PresentationServiceStopListeningForScreenAvailabilityParams _message = new PresentationServiceStopListeningForScreenAvailabilityParams();
            _message.url = url;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(STOP_LISTENING_FOR_SCREEN_AVAILABILITY_ORDINAL)));
        }

        @Override
        public void listenForDefaultSessionStart(ListenForDefaultSessionStartResponse callback) {
            PresentationServiceListenForDefaultSessionStartParams _message = new PresentationServiceListenForDefaultSessionStartParams();
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    LISTEN_FOR_DEFAULT_SESSION_START_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PresentationServiceListenForDefaultSessionStartResponseParamsForwardToCallback(callback));
        }

        @Override
        public void startSession(String presentationUrl, StartSessionResponse callback) {
            PresentationServiceStartSessionParams _message = new PresentationServiceStartSessionParams();
            _message.presentationUrl = presentationUrl;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    START_SESSION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PresentationServiceStartSessionResponseParamsForwardToCallback(callback));
        }

        @Override
        public void joinSession(String presentationUrl, String presentationId, JoinSessionResponse callback) {
            PresentationServiceJoinSessionParams _message = new PresentationServiceJoinSessionParams();
            _message.presentationUrl = presentationUrl;
            _message.presentationId = presentationId;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    JOIN_SESSION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PresentationServiceJoinSessionResponseParamsForwardToCallback(callback));
        }

        @Override
        public void sendSessionMessage(PresentationSessionInfo sessionInfo, SessionMessage messageRequest, SendSessionMessageResponse callback) {
            PresentationServiceSendSessionMessageParams _message = new PresentationServiceSendSessionMessageParams();
            _message.sessionInfo = sessionInfo;
            _message.messageRequest = messageRequest;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    SEND_SESSION_MESSAGE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PresentationServiceSendSessionMessageResponseParamsForwardToCallback(callback));
        }

        @Override
        public void closeSession(String presentationUrl, String presentationId) {
            PresentationServiceCloseSessionParams _message = new PresentationServiceCloseSessionParams();
            _message.presentationUrl = presentationUrl;
            _message.presentationId = presentationId;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(CLOSE_SESSION_ORDINAL)));
        }

        @Override
        public void listenForSessionStateChange() {
            PresentationServiceListenForSessionStateChangeParams _message = new PresentationServiceListenForSessionStateChangeParams();
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(LISTEN_FOR_SESSION_STATE_CHANGE_ORDINAL)));
        }

        @Override
        public void listenForSessionMessages(PresentationSessionInfo sessionInfo) {
            PresentationServiceListenForSessionMessagesParams _message = new PresentationServiceListenForSessionMessagesParams();
            _message.sessionInfo = sessionInfo;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(LISTEN_FOR_SESSION_MESSAGES_ORDINAL)));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<PresentationService> {

        Stub(org.chromium.mojo.system.Core core, PresentationService impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                PresentationService_Internal.MANAGER, messageWithHeader);
                    case SET_DEFAULT_PRESENTATION_URL_ORDINAL: {
                        PresentationServiceSetDefaultPresentationUrlParams data =
                                PresentationServiceSetDefaultPresentationUrlParams.deserialize(messageWithHeader.getPayload());
                        getImpl().setDefaultPresentationUrl(data.url);
                        return true;
                    }
                    case SET_CLIENT_ORDINAL: {
                        PresentationServiceSetClientParams data =
                                PresentationServiceSetClientParams.deserialize(messageWithHeader.getPayload());
                        getImpl().setClient(data.client);
                        return true;
                    }
                    case LISTEN_FOR_SCREEN_AVAILABILITY_ORDINAL: {
                        PresentationServiceListenForScreenAvailabilityParams data =
                                PresentationServiceListenForScreenAvailabilityParams.deserialize(messageWithHeader.getPayload());
                        getImpl().listenForScreenAvailability(data.url);
                        return true;
                    }
                    case STOP_LISTENING_FOR_SCREEN_AVAILABILITY_ORDINAL: {
                        PresentationServiceStopListeningForScreenAvailabilityParams data =
                                PresentationServiceStopListeningForScreenAvailabilityParams.deserialize(messageWithHeader.getPayload());
                        getImpl().stopListeningForScreenAvailability(data.url);
                        return true;
                    }
                    case CLOSE_SESSION_ORDINAL: {
                        PresentationServiceCloseSessionParams data =
                                PresentationServiceCloseSessionParams.deserialize(messageWithHeader.getPayload());
                        getImpl().closeSession(data.presentationUrl, data.presentationId);
                        return true;
                    }
                    case LISTEN_FOR_SESSION_STATE_CHANGE_ORDINAL: {
                        PresentationServiceListenForSessionStateChangeParams.deserialize(messageWithHeader.getPayload());
                        getImpl().listenForSessionStateChange();
                        return true;
                    }
                    case LISTEN_FOR_SESSION_MESSAGES_ORDINAL: {
                        PresentationServiceListenForSessionMessagesParams data =
                                PresentationServiceListenForSessionMessagesParams.deserialize(messageWithHeader.getPayload());
                        getImpl().listenForSessionMessages(data.sessionInfo);
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), PresentationService_Internal.MANAGER, messageWithHeader, receiver);
                    case LISTEN_FOR_DEFAULT_SESSION_START_ORDINAL: {
                        PresentationServiceListenForDefaultSessionStartParams.deserialize(messageWithHeader.getPayload());
                        getImpl().listenForDefaultSessionStart(new PresentationServiceListenForDefaultSessionStartResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case START_SESSION_ORDINAL: {
                        PresentationServiceStartSessionParams data =
                                PresentationServiceStartSessionParams.deserialize(messageWithHeader.getPayload());
                        getImpl().startSession(data.presentationUrl, new PresentationServiceStartSessionResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case JOIN_SESSION_ORDINAL: {
                        PresentationServiceJoinSessionParams data =
                                PresentationServiceJoinSessionParams.deserialize(messageWithHeader.getPayload());
                        getImpl().joinSession(data.presentationUrl, data.presentationId, new PresentationServiceJoinSessionResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case SEND_SESSION_MESSAGE_ORDINAL: {
                        PresentationServiceSendSessionMessageParams data =
                                PresentationServiceSendSessionMessageParams.deserialize(messageWithHeader.getPayload());
                        getImpl().sendSessionMessage(data.sessionInfo, data.messageRequest, new PresentationServiceSendSessionMessageResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class PresentationServiceSetDefaultPresentationUrlParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String url;
    
        private PresentationServiceSetDefaultPresentationUrlParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PresentationServiceSetDefaultPresentationUrlParams() {
            this(0);
        }
    
        public static PresentationServiceSetDefaultPresentationUrlParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PresentationServiceSetDefaultPresentationUrlParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PresentationServiceSetDefaultPresentationUrlParams result = new PresentationServiceSetDefaultPresentationUrlParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.url = decoder0.readString(8, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(url, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PresentationServiceSetDefaultPresentationUrlParams other = (PresentationServiceSetDefaultPresentationUrlParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.url, other.url))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(url);
            return result;
        }
    }

    static final class PresentationServiceSetClientParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public PresentationServiceClient client;
    
        private PresentationServiceSetClientParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PresentationServiceSetClientParams() {
            this(0);
        }
    
        public static PresentationServiceSetClientParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PresentationServiceSetClientParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PresentationServiceSetClientParams result = new PresentationServiceSetClientParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.client = decoder0.readServiceInterface(8, false, PresentationServiceClient.MANAGER);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(client, 8, false, PresentationServiceClient.MANAGER);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PresentationServiceSetClientParams other = (PresentationServiceSetClientParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.client, other.client))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(client);
            return result;
        }
    }

    static final class PresentationServiceListenForScreenAvailabilityParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String url;
    
        private PresentationServiceListenForScreenAvailabilityParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PresentationServiceListenForScreenAvailabilityParams() {
            this(0);
        }
    
        public static PresentationServiceListenForScreenAvailabilityParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PresentationServiceListenForScreenAvailabilityParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PresentationServiceListenForScreenAvailabilityParams result = new PresentationServiceListenForScreenAvailabilityParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.url = decoder0.readString(8, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(url, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PresentationServiceListenForScreenAvailabilityParams other = (PresentationServiceListenForScreenAvailabilityParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.url, other.url))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(url);
            return result;
        }
    }

    static final class PresentationServiceStopListeningForScreenAvailabilityParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String url;
    
        private PresentationServiceStopListeningForScreenAvailabilityParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PresentationServiceStopListeningForScreenAvailabilityParams() {
            this(0);
        }
    
        public static PresentationServiceStopListeningForScreenAvailabilityParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PresentationServiceStopListeningForScreenAvailabilityParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PresentationServiceStopListeningForScreenAvailabilityParams result = new PresentationServiceStopListeningForScreenAvailabilityParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.url = decoder0.readString(8, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(url, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PresentationServiceStopListeningForScreenAvailabilityParams other = (PresentationServiceStopListeningForScreenAvailabilityParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.url, other.url))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(url);
            return result;
        }
    }

    static final class PresentationServiceListenForDefaultSessionStartParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 8;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(8, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        private PresentationServiceListenForDefaultSessionStartParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PresentationServiceListenForDefaultSessionStartParams() {
            this(0);
        }
    
        public static PresentationServiceListenForDefaultSessionStartParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PresentationServiceListenForDefaultSessionStartParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PresentationServiceListenForDefaultSessionStartParams result = new PresentationServiceListenForDefaultSessionStartParams(mainDataHeader.elementsOrVersion);
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            return result;
        }
    }

    static final class PresentationServiceListenForDefaultSessionStartResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public PresentationSessionInfo defaultSessionInfo;
    
        private PresentationServiceListenForDefaultSessionStartResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PresentationServiceListenForDefaultSessionStartResponseParams() {
            this(0);
        }
    
        public static PresentationServiceListenForDefaultSessionStartResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PresentationServiceListenForDefaultSessionStartResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PresentationServiceListenForDefaultSessionStartResponseParams result = new PresentationServiceListenForDefaultSessionStartResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                result.defaultSessionInfo = PresentationSessionInfo.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(defaultSessionInfo, 8, true);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PresentationServiceListenForDefaultSessionStartResponseParams other = (PresentationServiceListenForDefaultSessionStartResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.defaultSessionInfo, other.defaultSessionInfo))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(defaultSessionInfo);
            return result;
        }
    }

    static class PresentationServiceListenForDefaultSessionStartResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final PresentationService.ListenForDefaultSessionStartResponse mCallback;

        PresentationServiceListenForDefaultSessionStartResponseParamsForwardToCallback(PresentationService.ListenForDefaultSessionStartResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(LISTEN_FOR_DEFAULT_SESSION_START_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                PresentationServiceListenForDefaultSessionStartResponseParams response = PresentationServiceListenForDefaultSessionStartResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.defaultSessionInfo);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PresentationServiceListenForDefaultSessionStartResponseParamsProxyToResponder implements PresentationService.ListenForDefaultSessionStartResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PresentationServiceListenForDefaultSessionStartResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(PresentationSessionInfo defaultSessionInfo) {
            PresentationServiceListenForDefaultSessionStartResponseParams _response = new PresentationServiceListenForDefaultSessionStartResponseParams();
            _response.defaultSessionInfo = defaultSessionInfo;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    LISTEN_FOR_DEFAULT_SESSION_START_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class PresentationServiceStartSessionParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String presentationUrl;
    
        private PresentationServiceStartSessionParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PresentationServiceStartSessionParams() {
            this(0);
        }
    
        public static PresentationServiceStartSessionParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PresentationServiceStartSessionParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PresentationServiceStartSessionParams result = new PresentationServiceStartSessionParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.presentationUrl = decoder0.readString(8, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(presentationUrl, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PresentationServiceStartSessionParams other = (PresentationServiceStartSessionParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.presentationUrl, other.presentationUrl))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(presentationUrl);
            return result;
        }
    }

    static final class PresentationServiceStartSessionResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public PresentationSessionInfo sessionInfo;
        public PresentationError error;
    
        private PresentationServiceStartSessionResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PresentationServiceStartSessionResponseParams() {
            this(0);
        }
    
        public static PresentationServiceStartSessionResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PresentationServiceStartSessionResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PresentationServiceStartSessionResponseParams result = new PresentationServiceStartSessionResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                result.sessionInfo = PresentationSessionInfo.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                result.error = PresentationError.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(sessionInfo, 8, true);
            encoder0.encode(error, 16, true);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PresentationServiceStartSessionResponseParams other = (PresentationServiceStartSessionResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.sessionInfo, other.sessionInfo))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.error, other.error))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(sessionInfo);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(error);
            return result;
        }
    }

    static class PresentationServiceStartSessionResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final PresentationService.StartSessionResponse mCallback;

        PresentationServiceStartSessionResponseParamsForwardToCallback(PresentationService.StartSessionResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(START_SESSION_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                PresentationServiceStartSessionResponseParams response = PresentationServiceStartSessionResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.sessionInfo, response.error);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PresentationServiceStartSessionResponseParamsProxyToResponder implements PresentationService.StartSessionResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PresentationServiceStartSessionResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(PresentationSessionInfo sessionInfo, PresentationError error) {
            PresentationServiceStartSessionResponseParams _response = new PresentationServiceStartSessionResponseParams();
            _response.sessionInfo = sessionInfo;
            _response.error = error;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    START_SESSION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class PresentationServiceJoinSessionParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String presentationUrl;
        public String presentationId;
    
        private PresentationServiceJoinSessionParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PresentationServiceJoinSessionParams() {
            this(0);
        }
    
        public static PresentationServiceJoinSessionParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PresentationServiceJoinSessionParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PresentationServiceJoinSessionParams result = new PresentationServiceJoinSessionParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.presentationUrl = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.presentationId = decoder0.readString(16, true);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(presentationUrl, 8, false);
            encoder0.encode(presentationId, 16, true);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PresentationServiceJoinSessionParams other = (PresentationServiceJoinSessionParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.presentationUrl, other.presentationUrl))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.presentationId, other.presentationId))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(presentationUrl);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(presentationId);
            return result;
        }
    }

    static final class PresentationServiceJoinSessionResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public PresentationSessionInfo sessionInfo;
        public PresentationError error;
    
        private PresentationServiceJoinSessionResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PresentationServiceJoinSessionResponseParams() {
            this(0);
        }
    
        public static PresentationServiceJoinSessionResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PresentationServiceJoinSessionResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PresentationServiceJoinSessionResponseParams result = new PresentationServiceJoinSessionResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                result.sessionInfo = PresentationSessionInfo.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                result.error = PresentationError.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(sessionInfo, 8, true);
            encoder0.encode(error, 16, true);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PresentationServiceJoinSessionResponseParams other = (PresentationServiceJoinSessionResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.sessionInfo, other.sessionInfo))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.error, other.error))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(sessionInfo);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(error);
            return result;
        }
    }

    static class PresentationServiceJoinSessionResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final PresentationService.JoinSessionResponse mCallback;

        PresentationServiceJoinSessionResponseParamsForwardToCallback(PresentationService.JoinSessionResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(JOIN_SESSION_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                PresentationServiceJoinSessionResponseParams response = PresentationServiceJoinSessionResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.sessionInfo, response.error);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PresentationServiceJoinSessionResponseParamsProxyToResponder implements PresentationService.JoinSessionResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PresentationServiceJoinSessionResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(PresentationSessionInfo sessionInfo, PresentationError error) {
            PresentationServiceJoinSessionResponseParams _response = new PresentationServiceJoinSessionResponseParams();
            _response.sessionInfo = sessionInfo;
            _response.error = error;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    JOIN_SESSION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class PresentationServiceSendSessionMessageParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public PresentationSessionInfo sessionInfo;
        public SessionMessage messageRequest;
    
        private PresentationServiceSendSessionMessageParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PresentationServiceSendSessionMessageParams() {
            this(0);
        }
    
        public static PresentationServiceSendSessionMessageParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PresentationServiceSendSessionMessageParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PresentationServiceSendSessionMessageParams result = new PresentationServiceSendSessionMessageParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.sessionInfo = PresentationSessionInfo.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.messageRequest = SessionMessage.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(sessionInfo, 8, false);
            encoder0.encode(messageRequest, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PresentationServiceSendSessionMessageParams other = (PresentationServiceSendSessionMessageParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.sessionInfo, other.sessionInfo))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.messageRequest, other.messageRequest))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(sessionInfo);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(messageRequest);
            return result;
        }
    }

    static final class PresentationServiceSendSessionMessageResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public boolean success;
    
        private PresentationServiceSendSessionMessageResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PresentationServiceSendSessionMessageResponseParams() {
            this(0);
        }
    
        public static PresentationServiceSendSessionMessageResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PresentationServiceSendSessionMessageResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PresentationServiceSendSessionMessageResponseParams result = new PresentationServiceSendSessionMessageResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.success = decoder0.readBoolean(8, 0);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(success, 8, 0);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PresentationServiceSendSessionMessageResponseParams other = (PresentationServiceSendSessionMessageResponseParams) object;
            if (this.success != other.success)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(success);
            return result;
        }
    }

    static class PresentationServiceSendSessionMessageResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final PresentationService.SendSessionMessageResponse mCallback;

        PresentationServiceSendSessionMessageResponseParamsForwardToCallback(PresentationService.SendSessionMessageResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SEND_SESSION_MESSAGE_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                PresentationServiceSendSessionMessageResponseParams response = PresentationServiceSendSessionMessageResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.success);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PresentationServiceSendSessionMessageResponseParamsProxyToResponder implements PresentationService.SendSessionMessageResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PresentationServiceSendSessionMessageResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean success) {
            PresentationServiceSendSessionMessageResponseParams _response = new PresentationServiceSendSessionMessageResponseParams();
            _response.success = success;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    SEND_SESSION_MESSAGE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class PresentationServiceCloseSessionParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String presentationUrl;
        public String presentationId;
    
        private PresentationServiceCloseSessionParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PresentationServiceCloseSessionParams() {
            this(0);
        }
    
        public static PresentationServiceCloseSessionParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PresentationServiceCloseSessionParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PresentationServiceCloseSessionParams result = new PresentationServiceCloseSessionParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.presentationUrl = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.presentationId = decoder0.readString(16, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(presentationUrl, 8, false);
            encoder0.encode(presentationId, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PresentationServiceCloseSessionParams other = (PresentationServiceCloseSessionParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.presentationUrl, other.presentationUrl))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.presentationId, other.presentationId))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(presentationUrl);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(presentationId);
            return result;
        }
    }

    static final class PresentationServiceListenForSessionStateChangeParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 8;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(8, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        private PresentationServiceListenForSessionStateChangeParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PresentationServiceListenForSessionStateChangeParams() {
            this(0);
        }
    
        public static PresentationServiceListenForSessionStateChangeParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PresentationServiceListenForSessionStateChangeParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PresentationServiceListenForSessionStateChangeParams result = new PresentationServiceListenForSessionStateChangeParams(mainDataHeader.elementsOrVersion);
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            return result;
        }
    }

    static final class PresentationServiceListenForSessionMessagesParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public PresentationSessionInfo sessionInfo;
    
        private PresentationServiceListenForSessionMessagesParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PresentationServiceListenForSessionMessagesParams() {
            this(0);
        }
    
        public static PresentationServiceListenForSessionMessagesParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PresentationServiceListenForSessionMessagesParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PresentationServiceListenForSessionMessagesParams result = new PresentationServiceListenForSessionMessagesParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.sessionInfo = PresentationSessionInfo.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(sessionInfo, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PresentationServiceListenForSessionMessagesParams other = (PresentationServiceListenForSessionMessagesParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.sessionInfo, other.sessionInfo))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(sessionInfo);
            return result;
        }
    }

}

